package net.w_horse.excelpojo.xml;

import java.util.HashMap;

import net.w_horse.excelpojo.ExcelPOJOBridge;
import net.w_horse.excelpojo.excel.cellseeker.CellSeeker;

import org.springframework.beans.factory.FactoryBean;

public class ExcelPOJOBeanFactoryBean implements FactoryBean {

	private String sheetName;
	private String targetClass = "";
	private String retrieveType;
	private CellSeeker cellSeeker;
	private HashMap<String, CellSeeker> targetClassProperties = new HashMap<String, CellSeeker>();


	@Override
	public Object getObject() throws Exception {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge();
		bridge.setSheetName(getSheetName());
		bridge.setTargetClass(getTargetClass());
		bridge.setRetrieveType(getRetrieveType());
		bridge.setCellSeeker(getCellSeeker());
		bridge.setTargetClassProperties(getTargetClassProperties());
		return bridge;
	}

	@Override
	public Class<ExcelPOJOBridge> getObjectType() {
		return ExcelPOJOBridge.class;
	}

	private boolean singleton = true;
	@Override
	public boolean isSingleton() {
		return this.singleton;
	}
	public void setSingleton(boolean singleton) {
		this.singleton = singleton;
	}

	public void setSheetName(String sheetName) {
		this.sheetName = sheetName;
	}

	public String getSheetName() {
		return sheetName;
	}

	public void setTargetClass(String targetClass) {
		this.targetClass = targetClass;
	}

	public String getTargetClass() {
		return targetClass;
	}

	public void setTargetClassProperties(HashMap<String, CellSeeker> targetClassProperties) {
		this.targetClassProperties = targetClassProperties;
	}

	public HashMap<String, CellSeeker> getTargetClassProperties() {
		return targetClassProperties;
	}

	public void setRetrieveType(String retrieveType) {
		this.retrieveType = retrieveType;
	}

	public String getRetrieveType() {
		return retrieveType;
	}

	public void setCellSeeker(CellSeeker cellSeeker) {
		this.cellSeeker = cellSeeker;
	}

	public CellSeeker getCellSeeker() {
		return cellSeeker;
	}
}
